IF  EXISTS (SELECT *
FROM SYS.OBJECTS
WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[EST_PED_VD_PAG_CONVENIO]') AND TYPE IN (N'U'))
BEGIN
	RETURN;
END
ELSE
BEGIN
	CREATE TABLE [DBO].[EST_PED_VD_PAG_CONVENIO](
		[CD_EMP] [INT] NOT NULL,
		[CD_FILIAL] [INT] NOT NULL,
		[CD_PED] [INT] NOT NULL,
		[CD_ORC_PAG] [INT] NOT NULL,
		[CD_CONV] [INT] NOT NULL,
		[CD_MDL_VD] [INT] NOT NULL,
		[PARCELA] [INT] NOT NULL,
		[VLR_PAG] [MONEY] NOT NULL,
	 CONSTRAINT [PK_EST_PED_VD_PAG_CONVENIO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PED] ASC,
		[CD_ORC_PAG] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	

	ALTER TABLE [DBO].[EST_PED_VD_PAG_CONVENIO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_PAG_CONVENIO_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
	REFERENCES [DBO].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])
	

	ALTER TABLE [DBO].[EST_PED_VD_PAG_CONVENIO] CHECK CONSTRAINT [FK_EST_PED_VD_PAG_CONVENIO_EST_PED_VD]
	
END